


<?php $__env->startSection('title'); ?>
    <?php echo e(localize('Languages')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('contents'); ?>
    <section class="tt-section pt-4">
        <div class="container">

            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('Languages')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e(localize('Languages')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-4 g-4">
                <!--left sidebar-->
                <div class="col-xl-9 order-2 order-md-2 order-lg-2 order-xl-1">
                    <div class="row">
                        <div class="col-12">
                            <div class="card mb-4" id="section-1">
                                <form class="app-search" action="<?php echo e(Request::fullUrl()); ?>" method="GET">
                                    <div class="card-header border-bottom-0">
                                        <div class="row justify-content-between g-3">
                                            <div class="col-auto flex-grow-1">
                                                <div class="tt-search-box">
                                                    <div class="input-group">
                                                        <span
                                                            class="position-absolute top-50 start-0 translate-middle-y ms-2">
                                                            <i data-feather="search"></i></span>
                                                        <input class="form-control rounded-start w-100" type="text"
                                                            id="search" name="search"
                                                            placeholder="<?php echo e(localize('Search')); ?>..."
                                                            <?php if(isset($searchKey)): ?>
                                        value="<?php echo e($searchKey); ?>"
                                    <?php endif; ?>>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-auto">
                                                <button type="submit" class="btn btn-primary">
                                                    <i data-feather="search" width="18"></i>
                                                    <?php echo e(localize('Search')); ?>

                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                                <table class="table tt-footable border-top" data-use-parent-width="true">
                                    <thead>
                                        <tr>
                                            <th class="text-center"><?php echo e(localize('S/L')); ?></th>
                                            <th><?php echo e(localize('Name')); ?></th>
                                            <th data-breakpoints="xs sm"><?php echo e(localize('ISO 639-1 Code')); ?></th>
                                            <th data-breakpoints="xs sm"><?php echo e(localize('MultiLangual Support')); ?></th>
                                            <th data-breakpoints="xs sm"><?php echo e(localize('Show In Templates')); ?></th>
                                            <th data-breakpoints="xs sm" class="text-end"><?php echo e(localize('Action')); ?>

                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="text-center">
                                                    <?php echo e($loop->index + 1); ?>

                                                </td>

                                                <td>
                                                    <a class="d-flex align-items-center">
                                                        <div class="avatar avatar-sm">
                                                            <img class="rounded-circle"
                                                                src="<?php echo e(staticAsset('backend/assets/img/flags/' . $language->flag . '.png')); ?>"
                                                                alt="<?php echo e($language->flag); ?>" />
                                                        </div>
                                                        <h6 class="fs-sm mb-0 ms-2"><?php echo e($language->name); ?>

                                                        </h6>
                                                    </a>
                                                </td>


                                                <td class="fw-semibold">
                                                    <?php echo e($language->code); ?>

                                                </td>

                                                <td>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('publish_languages')): ?>
                                                        <div class="form-check form-switch">
                                                            <input type="checkbox" class="form-check-input"
                                                                onchange="updateStatus(this)"
                                                                <?php if($language->is_active): ?> checked <?php endif; ?>
                                                                value="<?php echo e($language->id); ?>">
                                                        </div>
                                                    <?php endif; ?>
                                                </td>

                                                <td>
                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('publish_languages')): ?>
                                                        <div class="form-check form-switch">
                                                            <input type="checkbox" class="form-check-input"
                                                                onchange="updateTemplateStatus(this)"
                                                                <?php if($language->is_active_for_templates): ?> checked <?php endif; ?>
                                                                value="<?php echo e($language->id); ?>">
                                                        </div>
                                                    <?php endif; ?>
                                                </td>

                                                <td class="text-end">
                                                    <div class="dropdown tt-tb-dropdown">
                                                        <button type="button" class="btn p-0" data-bs-toggle="dropdown"
                                                            aria-expanded="false">
                                                            <i data-feather="more-vertical"></i>
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-end shadow">

                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit_languages')): ?>
                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('admin.languages.edit', $language->id)); ?>">
                                                                    <i data-feather="edit-3"
                                                                        class="me-2"></i><?php echo e(localize('Edit')); ?>

                                                                </a>
                                                            <?php endif; ?>

                                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('translate_languages')): ?>
                                                                <a class="dropdown-item"
                                                                    href="<?php echo e(route('admin.languages.localizations', $language->id)); ?>">
                                                                    <i data-feather="globe"
                                                                        class="me-2"></i><?php echo e(localize('Localizations')); ?>

                                                                </a>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add_languages')): ?>
                            <form action="<?php echo e(route('admin.languages.store')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <!--language info start-->
                                <div class="card mb-4" id="section-2">
                                    <div class="card-body">
                                        <h5 class="mb-4"><?php echo e(localize('Add New Language')); ?></h5>

                                        <div class="mb-4">
                                            <label for="name" class="form-label"><?php echo e(localize('Language Name')); ?></label>
                                            <input type="text" name="name" id="name"
                                                placeholder="<?php echo e(localize('Type language name')); ?>" class="form-control"
                                                required>
                                        </div>

                                        <div class="mb-4">
                                            <label for="code" class="form-label"><?php echo e(localize('ISO 639-1 Code')); ?></label>
                                            <input type="text" name="code" id="code"
                                                placeholder="<?php echo e(localize('en/bn')); ?>" class="form-control" required>
                                        </div>
                                        <div class="mb-4">
                                            <label for="symbol" class="form-label"><?php echo e(localize('Flag')); ?></label>
                                            <select id="flag" class="form-control country-flag-select" name="flag"
                                                data-toggle="select2">
                                                <?php $__currentLoopData = \File::files(base_path('public/backend/assets/img/flags')); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $path): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e(pathinfo($path)['filename']); ?>"
                                                        data-flag="<?php echo e(staticAsset('backend/assets/img/flags/' . pathinfo($path)['filename'] . '.png')); ?>">
                                                        <?php echo e(strtoupper(pathinfo($path)['filename'])); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="mb-4">
                                            <label for="symbol" class="form-label"><?php echo e(localize('Is RTL ?')); ?></label>
                                            <select id="is_rtl" class="form-control select2" name="is_rtl"
                                                data-toggle="select2">
                                                <option value="0">
                                                    <?php echo e(localize('No')); ?>

                                                </option>
                                                <option value="1">
                                                    <?php echo e(localize('Yes')); ?>

                                                </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <!--language info end-->

                                <div class="row">
                                    <div class="col-12">
                                        <div class="mb-4">
                                            <button class="btn btn-primary" type="submit">
                                                <i data-feather="save" class="me-1"></i> <?php echo e(localize('Save Language')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        <?php endif; ?>

                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('default_language')): ?>
                            <!--default lang info start-->
                            <div class="pb-650 mt-3">
                                <div class="card mb-4" id="section-3">
                                    <div class="card-body">
                                        <h5 class="mb-4"><?php echo e(localize('Set Default Language')); ?></h5>
                                        <div class="mb-4">
                                            <label for="symbol"
                                                class="form-label"><?php echo e(localize('Default Language')); ?></label>
                                            <select id="DEFAULT_LANGUAGE" class="form-control country-flag-select"
                                                name="DEFAULT_LANGUAGE" data-toggle="select2"
                                                onchange="handleDefaultLangSubmit(this)">
                                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($language->code); ?>"
                                                        <?php echo e(env('DEFAULT_LANGUAGE') == $language->code ? 'selected' : ''); ?>

                                                        data-flag="<?php echo e(staticAsset('backend/assets/img/flags/' . $language->flag . '.png')); ?>">
                                                        <?php echo e($language->name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--default lang info end-->
                        <?php endif; ?>
                    </div>
                </div>

                <!--right sidebar-->
                <div class="col-xl-3 order-1 order-md-1 order-lg-1 order-xl-2">
                    <div class="card tt-sticky-sidebar">
                        <div class="card-body">
                            <h5 class="mb-4"><?php echo e(localize('Language Information')); ?></h5>
                            <div class="tt-vertical-step">
                                <ul class="list-unstyled">
                                    <li>
                                        <a href="#section-1" class="active"><?php echo e(localize('All Languages')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-2"><?php echo e(localize('Add New Language')); ?></a>
                                    </li>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('default_language')): ?>
                                        <li>
                                            <a href="#section-3"><?php echo e(localize('Set Default Language')); ?></a>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict"

        function updateStatus(el) {
            if (el.checked) {
                var is_active = 1;
            } else {
                var is_active = 0;
            }
            $.post('<?php echo e(route('admin.languages.updateStatus')); ?>', {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: el.value,
                    is_active: is_active
                },
                function(data) {
                    if (data.demo) {
                        notifyMe('warning', data.message);
                    } else {
                        if (data.status == true) {
                            notifyMe('success', data.message);
                        } else {
                            notifyMe('danger', data.message);
                        }
                    }
                });
        }

        function updateTemplateStatus(el) {
            if (el.checked) {
                var is_active_for_templates = 1;
            } else {
                var is_active_for_templates = 0;
            }
            $.post('<?php echo e(route('admin.languages.updateTemplateStatus')); ?>', {
                    _token: '<?php echo e(csrf_token()); ?>',
                    id: el.value,
                    is_active_for_templates: is_active_for_templates
                },
                function(data) {
                    if (data.demo) {
                        notifyMe('warning', data.message);
                    } else {
                        if (data.status == true) {
                            notifyMe('success', data.message);
                        } else {
                            notifyMe('danger', data.message);
                        }
                    }
                });
        }

        function handleDefaultLangSubmit(el) {
            $.post('<?php echo e(route('admin.languages.defaultLanguage')); ?>', {
                    _token: '<?php echo e(csrf_token()); ?>',
                    DEFAULT_LANGUAGE: el.value
                },
                function(data) {
                    if (data.demo) {
                        notifyMe('warning', data.message);
                    } else {
                        notifyMe('success', data.message);
                    }

                });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\baleaspirasi\resources\views/backend/pages/systemSettings/language.blade.php ENDPATH**/ ?>