

<?php $__env->startSection('title'); ?>
    <?php echo e(localize('General Settings')); ?> <?php echo e(getSetting('title_separator')); ?> <?php echo e(getSetting('system_title')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('contents'); ?>
    <section class="tt-section pt-4">
        <div class="container">


            <div class="row mb-4">
                <div class="col-12">
                    <div class="tt-page-header">
                        <div class="d-lg-flex align-items-center justify-content-lg-between">
                            <div class="tt-page-title mb-3 mb-lg-0">
                                <h1 class="h4 mb-lg-1"><?php echo e(localize('General Settings')); ?></h1>
                                <ol class="breadcrumb breadcrumb-angle text-muted">
                                    <li class="breadcrumb-item"><a
                                            href="<?php echo e(route('writebot.dashboard')); ?>"><?php echo e(localize('Dashboard')); ?></a>
                                    </li>
                                    <li class="breadcrumb-item"><?php echo e(localize('General Settings')); ?></li>
                                </ol>
                            </div>
                            <div class="tt-action">
                                <?php if (isset($component)) { $__componentOriginal3a0007b8d43940d96038815b29fa2d03631850fa = $component; } ?>
<?php $component = App\View\Components\ChangeLanguage::resolve(['langkey' => $lang_key] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('change-language'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(App\View\Components\ChangeLanguage::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3a0007b8d43940d96038815b29fa2d03631850fa)): ?>
<?php $component = $__componentOriginal3a0007b8d43940d96038815b29fa2d03631850fa; ?>
<?php unset($__componentOriginal3a0007b8d43940d96038815b29fa2d03631850fa); ?>
<?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row g-4 pb-650">
                <!--left sidebar-->
                <div class="col-xl-9 order-2 order-md-2 order-lg-2 order-xl-1">

                    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data"
                        class="">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="language_key" id="language_id" value="<?php echo e($lang_key); ?>">
                        <?php if(checkLanguage($lang_key)): ?>
                            <!--general settings-->
                            <div class="card mb-4" id="section-1">
                                <div class="card-body">
                                    <h5 class="mb-4"><?php echo e(localize('General Informations')); ?></h5>

                                    <div class="mb-3">
                                        <label for="system_title" class="form-label"><?php echo e(localize('System Title')); ?></label>
                                        <input type="hidden" name="types[]" value="system_title">
                                        <input type="text" id="system_title" name="system_title" class="form-control"
                                            value="<?php echo e(getSetting('system_title')); ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="title_separator"
                                            class="form-label"><?php echo e(localize('Browser Tab Title Separator')); ?></label>
                                        <input type="hidden" name="types[]" value="title_separator">
                                        <input type="text" id="title_separator" name="title_separator"
                                            class="form-control" value="<?php echo e(getSetting('title_separator')); ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="contact_email"
                                            class="form-label"><?php echo e(localize('Contact Email')); ?></label>
                                        <input type="hidden" name="types[]" value="contact_email">
                                        <input type="text" id="contact_email" name="contact_email" class="form-control"
                                            value="<?php echo e(getSetting('contact_email')); ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="contact_phone"
                                            class="form-label"><?php echo e(localize('Contact Phone')); ?></label>
                                        <input type="hidden" name="types[]" value="contact_phone">
                                        <input type="text" id="contact_phone" name="contact_phone" class="form-control"
                                            value="<?php echo e(getSetting('contact_phone')); ?>">
                                    </div>

                                    <div class="mb-3">
                                        <label for="enable_preloader"
                                            class="form-label"><?php echo e(localize('Enable Preloader')); ?></label>
                                        <input type="hidden" name="types[]" value="enable_preloader">
                                        <select id="enable_preloader" class="form-control text-uppercase select2"
                                            name="enable_preloader" data-toggle="select2">
                                            <option value="" disabled selected><?php echo e(localize('Set preloader status')); ?>

                                            </option>
                                            <option value="1"
                                                <?php echo e(getSetting('enable_preloader') == '1' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Enable')); ?></option>
                                            <option value="0"
                                                <?php echo e(getSetting('enable_preloader') == '0' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                        </select>
                                    </div>

                                </div>
                            </div>
                            <!--general settings-->



                            <!--logo settings-->
                            <div class="card mb-4" id="section-3">
                                <div class="card-body">
                                    <h5 class="mb-4"><?php echo e(localize('Dashboard Logo & Favicon')); ?></h5>
                                    <div class="mb-3">
                                        <label for="admin_panel_logo"
                                            class="form-label"><?php echo e(localize('Dashboard logo for light version')); ?></label>
                                        <input type="hidden" name="types[]" value="admin_panel_logo">
                                        <div class="tt-image-drop rounded">
                                            <span class="fw-semibold"><?php echo e(localize('Choose Dark Logo')); ?></span>
                                            <!-- choose media -->
                                            <div class="tt-product-thumb show-selected-files mt-3">
                                                <div class="avatar avatar-xl cursor-pointer choose-media"
                                                    data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom"
                                                    onclick="showMediaManager(this)" data-selection="single">
                                                    <input type="hidden" name="admin_panel_logo"
                                                        value="<?php echo e(getSetting('admin_panel_logo')); ?>">
                                                    <div class="no-avatar rounded-circle">
                                                        <span><i data-feather="plus"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- choose media -->
                                        </div>
                                    </div>
                                    <div class="mb-3">
                                        <label for="admin_panel_logo_dark"
                                            class="form-label"><?php echo e(localize('Dashboard logo for dark version')); ?></label>
                                        <input type="hidden" name="types[]" value="admin_panel_logo_dark">
                                        <div class="tt-image-drop rounded">
                                            <span class="fw-semibold"><?php echo e(localize('Choose Light Logo')); ?></span>
                                            <!-- choose media -->
                                            <div class="tt-product-thumb show-selected-files mt-3">
                                                <div class="avatar avatar-xl cursor-pointer choose-media"
                                                    data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom"
                                                    onclick="showMediaManager(this)" data-selection="single">
                                                    <input type="hidden" name="admin_panel_logo_dark"
                                                        value="<?php echo e(getSetting('admin_panel_logo_dark')); ?>">
                                                    <div class="no-avatar rounded-circle">
                                                        <span><i data-feather="plus"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- choose media -->
                                        </div>
                                    </div>

                                    <div class="mb-3">
                                        <label for="favicon" class="form-label"><?php echo e(localize('Favicon')); ?></label>
                                        <input type="hidden" name="types[]" value="favicon">
                                        <div class="tt-image-drop rounded">
                                            <span class="fw-semibold"><?php echo e(localize('Choose Favicon')); ?></span>
                                            <!-- choose media -->
                                            <div class="tt-product-thumb show-selected-files mt-3">
                                                <div class="avatar avatar-xl cursor-pointer choose-media"
                                                    data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom"
                                                    onclick="showMediaManager(this)" data-selection="single">
                                                    <input type="hidden" name="favicon"
                                                        value="<?php echo e(getSetting('favicon')); ?>">
                                                    <div class="no-avatar rounded-circle">
                                                        <span><i data-feather="plus"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- choose media -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--logo settings-->

                            <!--maintenance mode settings-->
                            <div class="card mb-4" id="section-4">
                                <div class="card-body">
                                    <h5 class="mb-4"><?php echo e(localize('Maintenance Mode')); ?></h5>
                                    <div class="mb-3">
                                        <label for="enable_maintenance_mode"
                                            class="form-label"><?php echo e(localize('Enable Maintenance Mode')); ?></label>
                                        <input type="hidden" name="types[]" value="enable_maintenance_mode">
                                        <select id="enable_maintenance_mode" class="form-control text-uppercase select2"
                                            name="enable_maintenance_mode" data-toggle="select2">
                                            <option value="" disabled selected>
                                                <?php echo e(localize('Set maintenance mode')); ?>

                                            </option>
                                            <option value="1"
                                                <?php echo e(getSetting('enable_maintenance_mode') == '1' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Enable')); ?></option>
                                            <option value="0"
                                                <?php echo e(getSetting('enable_maintenance_mode') == '0' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <!--maintenance mode settings-->

                            <!--frontend  settings-->
                            <div class="card mb-4" id="section-10">
                                <div class="card-body">
                                    <h5 class="mb-4"><?php echo e(localize('Frontend/Landing Page')); ?></h5>
                                    <div class="mb-3">
                                        <label for="enable_frontend" class="form-label"><?php echo e(localize('Frontend Status')); ?>

                                            <span>(<?php echo e(localize('if disable only login, registration page show other all frontend page not visiable')); ?>)</span></label>
                                        <input type="hidden" name="types[]" value="enable_frontend">
                                        <select id="enable_frontend" class="form-control text-uppercase select2"
                                            name="enable_frontend" data-toggle="select2">

                                            <option value="yes"
                                                <?php echo e(getSetting('enable_frontend') == 'yes' || !getSetting('enable_frontend') ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Enable')); ?></option>
                                            <option value="no"
                                                <?php echo e(getSetting('enable_frontend') == 'no' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <!--frontend mode settings-->

                            <!--seo meta description start-->
                            <div class="card mb-4" id="section-5">
                                <div class="card-body">
                                    <h5 class="mb-4"><?php echo e(localize('SEO Meta Configuration')); ?></h5>

                                    <div class="mb-4">
                                        <label for="global_meta_title"
                                            class="form-label"><?php echo e(localize('Meta Title')); ?></label>
                                        <input type="hidden" name="types[]" value="global_meta_title">
                                        <input type="text" name="global_meta_title" id="global_meta_title"
                                            placeholder="<?php echo e(localize('Type meta title')); ?>" class="form-control"
                                            value="<?php echo e(getSetting('global_meta_title')); ?>">
                                        <span class="fs-sm text-muted">
                                            <?php echo e(localize('Set a meta tag title. Recommended to be simple and unique.')); ?>

                                        </span>
                                    </div>

                                    <div class="mb-4">
                                        <label for="global_meta_description"
                                            class="form-label"><?php echo e(localize('Meta Description')); ?></label>
                                        <input type="hidden" name="types[]" value="global_meta_description">
                                        <textarea class="form-control" name="global_meta_description" id="global_meta_description" rows="4"
                                            placeholder="<?php echo e(localize('Type your meta description')); ?>"><?php echo e(getSetting('global_meta_description')); ?></textarea>
                                    </div>

                                    <div class="mb-4">
                                        <label for="global_meta_keywords"
                                            class="form-label"><?php echo e(localize('Meta Keywords')); ?></label>

                                        <input type="hidden" name="types[]" value="global_meta_keywords">
                                        <textarea class="form-control" name="global_meta_keywords" id="global_meta_keywords" placeholder="Keyword, Keyword"><?php echo e(getSetting('global_meta_keywords')); ?></textarea>
                                    </div>

                                    <div class="mb-4">
                                        <label class="form-label"><?php echo e(localize('Meta Image')); ?></label>
                                        <input type="hidden" name="types[]" value="global_meta_image">
                                        <div class="tt-image-drop rounded">
                                            <span class="fw-semibold"><?php echo e(localize('Choose Meta Image')); ?></span>
                                            <!-- choose media -->
                                            <div class="tt-product-thumb show-selected-files mt-3">
                                                <div class="avatar avatar-xl cursor-pointer choose-media"
                                                    data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom"
                                                    onclick="showMediaManager(this)" data-selection="single">
                                                    <input type="hidden" name="global_meta_image"
                                                        value="<?php echo e(getSetting('global_meta_image')); ?>">
                                                    <div class="no-avatar rounded-circle">
                                                        <span><i data-feather="plus"></i></span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- choose media -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!--seo meta description end-->
                        <?php endif; ?>
                        <!--Cookie Consent settings-->
                        <div class="card mb-4" id="section-6">
                            <div class="card-body">
                                <h5 class="mb-4"><?php echo e(localize('Cookie Consent')); ?></h5>
                                <?php if(checkLanguage($lang_key)): ?>
                                    <div class="mb-3">
                                        <label for="enable_cookie_consent"
                                            class="form-label"><?php echo e(localize('Show Cookie Consent')); ?></label>
                                        <input type="hidden" name="types[]" value="enable_cookie_consent">
                                        <select id="enable_cookie_consent" class="form-control text-uppercase select2"
                                            name="enable_cookie_consent" data-toggle="select2">
                                            <option value="" disabled selected>
                                                <?php echo e(localize('Select an option')); ?>

                                            </option>
                                            <option value="1"
                                                <?php echo e(getSetting('enable_cookie_consent') == '1' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Enable')); ?></option>
                                            <option value="0"
                                                <?php echo e(getSetting('enable_cookie_consent') == '0' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                        </select>
                                    </div>
                                <?php endif; ?>
                                <div class="mb-3">
                                    <label for="cookie_consent_text"
                                        class="form-label"><?php echo e(localize('Cookie Consent Text')); ?></label>
                                    <input type="hidden" name="types[]" value="cookie_consent_text">
                                    <textarea name="cookie_consent_text" id="cookie_consent_text" class="editor form-control"><?php echo e(systemSettingsLocalization('cookie_consent_text', $lang_key)); ?></textarea>
                                </div>
                            </div>
                        </div>
                        <!--Cookie Consent settings-->
                        <div class="mb-3">
                            <button class="btn btn-primary" type="submit">
                                <i data-feather="save" class="me-1"></i> <?php echo e(localize('Save Configuration')); ?>

                            </button>
                        </div>

                       
                    </form>

                   

                    <?php if(checkLanguage($lang_key)): ?>
                    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <!-- custom scripts -->
                        <div class="card mb-4" id="section-7">
                            <div class="card-body">
                                <h5 class="mb-4"><?php echo e(localize('Custom Scripts')); ?></h5>

                                <div class="mb-3">
                                    <label for="header_custom_scripts"
                                           class="form-label"><?php echo e(localize('Header custom script - before </head>')); ?></label>
                                    <input type="hidden" name="types[]" value="header_custom_scripts">
                                    <textarea rows="5"
                                              name="header_custom_scripts"
                                              id="header_custom_scripts"
                                              placeholder="<script></script>"
                                              class="form-control"><?php echo e(getSetting('header_custom_scripts')); ?></textarea>

                                    <small>*<?php echo e(localize('Copy or write your custom script here')); ?></small>
                                </div>

                                <div class="mb-3">
                                    <label for="footer_custom_scripts"
                                           class="form-label"><?php echo e(localize('Footer custom script - before </body>')); ?></label>
                                    <input type="hidden" name="types[]" value="footer_custom_scripts">
                                    <textarea rows="5"
                                              name="footer_custom_scripts"
                                              id="footer_custom_scripts"
                                              placeholder="<script></script>"
                                              class="form-control"><?php echo e(getSetting('footer_custom_scripts')); ?></textarea>

                                    <small>*<?php echo e(localize('Copy or write your custom script here')); ?></small>
                                </div>
                                    <h5 class="mb-4"><?php echo e(localize('Custom Css')); ?></h5>
    
                                    <div class="mb-3">
                                        <label for="header_custom_css"
                                               class="form-label"><?php echo e(localize('Custom css - before </head>')); ?></label>
                                        <input type="hidden" name="types[]" value="header_custom_css">
                                        <textarea rows="5"
                                                  name="header_custom_css"
                                                  id="header_custom_css"
                                                  placeholder="<style></style>"
                                                  class="form-control"><?php echo e(getSetting('header_custom_css')); ?></textarea>
    
                                        <small>*<?php echo e(localize('Copy or write your custom css here')); ?></small>
                                    </div>
                            </div>
                        </div>
                        <!--custom scripts-->
                        <div class="mb-3">
                            <button class="btn btn-primary saveCustomScripts" type="button">
                                <i data-feather="save" class="me-1"></i> <?php echo e(localize('Save Configuration')); ?>

                            </button>
                        </div>

                       
                    </form>
                    <?php endif; ?>
                   
                    <?php if(checkLanguage($lang_key)): ?>
                        <form action="<?php echo e(route('admin.envKey.update')); ?>" method="POST" enctype="multipart/form-data"
                            class="mt-5">
                            <?php echo csrf_field(); ?>
                            <!--google analytics-->
                            <div class="card mb-4" id="section-8">
                                <div class="card-body">
                                    <h5 class="mb-4"><?php echo e(localize('Google Analytics')); ?></h5>

                                    <div class="mb-3">
                                        <label for="ENABLE_GOOGLE_ANALYTICS"
                                            class="form-label"><?php echo e(localize('Google Analytics')); ?></label>
                                        <input type="hidden" name="types[]" value="ENABLE_GOOGLE_ANALYTICS">
                                        <select id="ENABLE_GOOGLE_ANALYTICS" class="form-control text-uppercase select2"
                                            name="ENABLE_GOOGLE_ANALYTICS" data-toggle="select2">
                                            <option value="" disabled selected>
                                                <?php echo e(localize('Enable Google Analytics')); ?>

                                            </option>
                                            <option value="1"
                                                <?php echo e(env('ENABLE_GOOGLE_ANALYTICS') == '1' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Enable')); ?></option>
                                            <option value="0"
                                                <?php echo e(env('ENABLE_GOOGLE_ANALYTICS') == '0' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="TRACKING_ID" class="form-label"><?php echo e(localize('Tracking ID')); ?></label>
                                        <input type="hidden" name="types[]" value="TRACKING_ID">
                                        <input type="text" id="TRACKING_ID" name="TRACKING_ID" class="form-control"
                                            value="<?php echo e(env('TRACKING_ID')); ?>">
                                    </div>
                                </div>
                            </div>
                            <!--google analytics-->

                            <div class="mb-3">
                                <button class="btn btn-primary" type="submit">
                                    <i data-feather="save" class="me-1"></i> <?php echo e(localize('Save Configuration')); ?>

                                </button>
                            </div>
                        </form>


                        <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data"
                            class="mt-5 adscenseForm">
                            <?php echo csrf_field(); ?>
                            <!--google analytics-->
                            <div class="card mb-4" id="section-11">
                                <div class="card-body">
                                    <h5 class="mb-4"><?php echo e(localize('Google ADSENSE')); ?> </h5>
                                    <div class="mb-3">
                                        <label for="header_custom_scripts"
                                            class="form-label"><?php echo e(localize('AdSense code snippet')); ?> <?php if (isset($component)) { $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4 = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.required-star','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('required-star'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4)): ?>
<?php $component = $__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4; ?>
<?php unset($__componentOriginalc254754b9d5db91d5165876f9d051922ca0066f4); ?>
<?php endif; ?></label>
                                        <input type="hidden" name="types[]" value="adsense_code_snippet">
                                        <textarea rows="5" name="adsense_code_snippet" id="adsense_code_snippet"
                                            placeholder="" class="form-control"><?php echo e(getSetting('adsense_code_snippet')); ?></textarea>

                                    </div>
                                    <div class="mb-3">
                                        <label for="enable_google_adsense"
                                            class="form-label"><?php echo e(localize('Google ADSENSE Status')); ?></label>
                                        <input type="hidden" name="types[]" value="enable_google_adsense">
                                        <select id="enable_google_adsense" class="form-control text-uppercase select2"
                                            name="enable_google_adsense" data-toggle="select2">
                                            <option value="" disabled selected>
                                                <?php echo e(localize('Enable Google ADSENSE')); ?>

                                            </option>
                                            <option value="1"
                                                <?php echo e(getSetting('enable_google_adsense') == '1' ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Enable')); ?></option>
                                            <option value="0"
                                                <?php echo e(getSetting('enable_google_adsense') == '0' || !getSetting('enable_google_adsense') ? 'selected' : ''); ?>>
                                                <?php echo e(localize('Disable')); ?></option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <!--google analytics-->

                            <div class="mb-3">
                                <button class="btn btn-primary" type="submit">
                                    <i data-feather="save" class="me-1"></i> <?php echo e(localize('Save Configuration')); ?>

                                </button>
                            </div>
                        </form>
                    <?php endif; ?>

                    <form action="<?php echo e(route('admin.envKey.update')); ?>" method="POST" enctype="multipart/form-data"
                        class="mt-5">
                        <?php echo csrf_field(); ?>
                        <!--google analytics-->
                        <div class="card mb-4" id="section-9">
                            <div class="card-body">
                                <h5 class="mb-4"><?php echo e(localize('Subscription Settings')); ?></h5>

                                <div class="mb-3">
                                    <div class="form-check tt-checkbox">
                                        <label for="carry_forward" class="form-check-label fw-medium ">
                                            <input class="form-check-input cursor-pointer subcriptionSettings"
                                                data-type="carry_forward" onchange="updateStatus(this)" type="checkbox"
                                                id="carry_forward"
                                                <?php echo e(getSetting('carry_forward') == 1 ? 'checked' : ''); ?>>
                                            <strong><?php echo e(localize('Balance Carry Forward: ')); ?></strong>
                                            <?php echo e(localize('Remaining balance from active package(only for active) will be added to next package balance.')); ?>

                                        </label>
                                        <?php echo e(localize('This service is applicable for same package - Lifetime to Lifetime, Yearly to Yearly, Monthly to Monthly and Prepaid to Prepaid pacakge.')); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                        <!--google analytics-->

                    </form>
                    <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data"
                    class="">
                    <?php echo csrf_field(); ?>

                    <div class="card mb-4" id="section-12">
                        <div class="card-body">
                            <h5 class="mb-4"><?php echo e(localize('Scroll Bar Icon')); ?></h5>

                            <div class="mb-4">
                                <label class="form-label"><?php echo e(localize('Scroll Bar Icon')); ?></label>
                                <input type="hidden" name="types[]" value="scrol_to_top_image">
                                <div class="tt-image-drop rounded">
                                    <span class="fw-semibold"><?php echo e(localize('Choose Scroll Bar Icon')); ?></span>
                                    <!-- choose media -->
                                    <div class="tt-product-thumb show-selected-files mt-3">
                                        <div class="avatar avatar-xl cursor-pointer choose-media"
                                            data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom"
                                            onclick="showMediaManager(this)" data-selection="single">
                                            <input type="hidden" name="scrol_to_top_image"
                                                value="<?php echo e(getSetting('scrol_to_top_image')); ?>">
                                            <div class="no-avatar rounded-circle">
                                                <span><i data-feather="plus"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- choose media -->
                                </div>
                            </div>

                        </div>

                    </div>
                    <div class="mb-3">
                        <button class="btn btn-primary" type="submit">
                            <i data-feather="save" class="me-1"></i> <?php echo e(localize('Save Configuration')); ?>

                        </button>
                    </div>
                    </form>
                </div>

                <!--right sidebar-->
                <div class="col-xl-3 order-1 order-md-1 order-lg-1 order-xl-2">
                    <div class="card tt-sticky-sidebar">
                        <div class="card-body">
                            <h5 class="mb-4"><?php echo e(localize('Configure General Settings')); ?></h5>
                            <div class="tt-vertical-step">
                                <ul class="list-unstyled">
                                    <li>
                                        <a href="#section-1" class="active"><?php echo e(localize('General Information')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-3"><?php echo e(localize('Dashborad Logo & Favicon')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-4"><?php echo e(localize('Maintenance Mode')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-10"><?php echo e(localize('Frontend Settings')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-5"><?php echo e(localize('SEO Configuration')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-6"><?php echo e(localize('Cookie Consent')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-7"><?php echo e(localize('Custom Scripts')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-css"><?php echo e(localize('Custom Css')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-8"><?php echo e(localize('Google Analytics')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-11"><?php echo e(localize('Google Adsense')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-9"><?php echo e(localize('Subscription Settings')); ?></a>
                                    </li>
                                    <li>
                                        <a href="#section-12"><?php echo e(localize('Scroll Bar Icon')); ?></a>
                                    </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
    <script>
        "use strict";

        // runs when the document is ready --> for media files
        $(document).ready(function() {
            getChosenFilesCount();
            showSelectedFilePreviewOnLoad();
        });

        function updateStatus(el) {
            let type = $(el).data('type');
            if (el.checked) {
                var is_active = 1;
            } else {
                var is_active = 0;
            }

            $.post('<?php echo e(route('admin.subscription-settings.store')); ?>', {
                    _token: '<?php echo e(csrf_token()); ?>',
                    is_active: is_active,
                    type: type,

                },
                function(data) {
                    if (data == 1) {
                        notifyMe('success', '<?php echo e(localize('Status updated successfully')); ?>');
                    } else {
                        notifyMe('danger', '<?php echo e(localize('Something went wrong')); ?>');
                    }
                });
        }

        /**
         * Save Custom Scripts
         * */


         let entityMap = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#39;',
            '/': '&#x2F;',
            '`': '&#x60;',
            '=': '&#x3D;'
        };

        $(document).on("click",".saveCustomScripts",function () {
            let headerCustomScript =  $("#header_custom_scripts").val();
            let footerCustomScript =  $("#footer_custom_scripts").val();
            let customCss          =  $("#header_custom_css").val();

            headerCustomScript = escapeHtml(headerCustomScript);
            footerCustomScript = escapeHtml(footerCustomScript);
            customCss          = escapeHtml(customCss);

            // Write a Post ajax request

            let types = [
                "header_custom_scripts",
                "footer_custom_scripts",
                "header_custom_css"
            ];

            let typeValues = [
                headerCustomScript,
                footerCustomScript,
                customCss
            ];

            $.ajax({
                url : "<?php echo e(route('admin.settings.update')); ?>",
                type: "POST",
                data: {
                    _token     : '<?php echo e(csrf_token()); ?>',
                    types      : types,
                    typeValues : typeValues,
                },
                dataType : "JSON",
                success: function(response) {                   
                    notifyMe("success",response.message ?? "<?php echo e(localize('Saved Successfully')); ?>");
                    location.reload();
                },
            })
        });



        function escapeHtml (string) {

            return String(string).replace(/[&<>"'`=\/]/g, function (s) {
                return entityMap[s];
            });
        }
        

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\xampp\htdocs\ai\baleaspirasi\resources\views/backend/pages/systemSettings/general.blade.php ENDPATH**/ ?>