<!DOCTYPE html>

<?php
    $locale = str_replace('_', '-', app()->getLocale()) ?? 'en';
    $localLang = \App\Models\Language::where('code', $locale)->first();
?>

<?php if(@$localLang->is_rtl == 1): ?>
    <html dir="rtl" lang="<?php echo e($locale); ?>" data-bs-theme="<?php echo e(getSetting('theme_mode') ?? 'light'); ?>">
<?php else: ?>
    <html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>"
        data-bs-theme="<?php echo e(getSetting('theme_mode') ?? 'light'); ?>">
<?php endif; ?>

<head>
    <!--required meta tags-->
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php if(!empty($_SERVER['HTTPS'])): ?>
        <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests" />
    <?php endif; ?>

    <!--favicon icon-->
    <link rel="shortcut icon" href="<?php echo e(uploadedAsset(getSetting('favicon'))); ?>">

    <!--meta-->
    <meta name="robots" content="index, follow">
    <meta itemprop="name" content="<?php echo e(getSetting('global_meta_title')); ?>" />

    <!--title-->
    <title>
        <?php echo $__env->yieldContent('title', getSetting('system_title')); ?>
    </title>
    <?php $config = (new \LaravelPWA\Services\ManifestService)->generate(); echo $__env->make( 'laravelpwa::meta' , ['config' => $config])->render(); ?>
    <?php if(env('ENABLE_GOOGLE_ANALYTICS') == 1): ?>
        <!-- Global site tag (gtag.js) - Google Analytics -->
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(env('TRACKING_ID')); ?>"></script>

        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config', '<?php echo e(env('TRACKING_ID')); ?>');
        </script>
    <?php endif; ?>

    <?php echo $__env->yieldContent('meta'); ?>

    <?php if(!isset($blog)): ?>

        <meta name="title" content="<?php echo e(getSetting('global_meta_title')); ?>">
        <meta name="description" content="<?php echo e(getSetting('global_meta_description')); ?>">
        <meta name="keywords" content="<?php echo e(getSetting('global_meta_keywords')); ?>">
        <!-- Schema.org markup for Google+ -->

        <meta itemprop="image" content="<?php echo e(uploadedAsset(getSetting('global_meta_image'))); ?>" />


        <!-- Twitter Card data -->
        <meta name="twitter:card" content="product" />
        <meta name="twitter:site" content="@publisher_handle" />
        <meta name="twitter:title" content="<?php echo e(getSetting('global_meta_title')); ?>" />
        <meta name="twitter:description" content="<?php echo e(getSetting('global_meta_description')); ?>" />
        <meta name="twitter:creator"
            content="@author_handle"/>
        <meta name="twitter:image" content="<?php echo e(uploadedAsset(getSetting('global_meta_image'))); ?>"/>

        <!-- Open Graph data -->
        <meta property="og:title" content="<?php echo e(getSetting('global_meta_title')); ?>" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?php echo e(route('home')); ?>" />
        <meta property="og:image" content="<?php echo e(uploadedAsset(getSetting('global_meta_image'))); ?>" />
        <meta property="og:description" content="<?php echo e(getSetting('global_meta_description')); ?>" />
        <meta property="og:site_name" content="<?php echo e(env('APP_NAME')); ?>" /> 
        <meta property="fb:app_id" content="<?php echo e(env('FACEBOOK_PIXEL_ID')); ?>">

    <?php else: ?>
    
        <meta name="title" content="<?php echo e($blog->meta_title); ?>"> 
        <meta name="description" content="<?php echo e($blog->meta_description); ?>"> 

        <!-- Schema.org markup for Google+ --> 

        <meta itemprop="image" content="<?php echo e(uploadedAsset($blog->meta_img)); ?>" />

        <!-- Twitter Card data -->
        <meta name="twitter:card" content="product" />
        <meta name="twitter:site" content="@publisher_handle" />
        <meta name="twitter:title" content="<?php echo e($blog->meta_title); ?>" />
        <meta name="twitter:description" content="<?php echo e($blog->meta_description); ?>" />
        <meta name="twitter:creator"
            content="@author_handle"/>
        <meta name="twitter:image" content="<?php echo e(uploadedAsset($blog->meta_img)); ?>"/>

        <!-- Open Graph data -->
        <meta property="og:title" content="<?php echo e($blog->meta_title); ?>" />
        <meta property="og:type" content="website" />
        <meta property="og:url" content="<?php echo e(route('home')); ?>" />
        <meta property="og:description" content="<?php echo e($blog->meta_description); ?>" />
        <meta property="og:image" content="<?php echo e(uploadedAsset($blog->meta_img)); ?>" />
        <meta property="og:site_name" content="<?php echo e(env('APP_NAME')); ?>" /> 
        <meta property="fb:app_id" content="<?php echo e(env('FACEBOOK_PIXEL_ID')); ?>">
    <?php endif; ?>

    <!-- recaptcha -->
    <?php if(getSetting('enable_recaptcha') == 1): ?>
        <?php echo RecaptchaV3::initJs(); ?>

    <?php endif; ?>
    <?php if(env('ENABLE_GOOGLE_ADSENSE') == 1): ?>

    <?php endif; ?>
    <!-- recaptcha -->

    <!-- head-scripts -->
    <?php echo $__env->make('frontend.default.inc.head-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- head-scripts -->

    <!--build:css-->
    <?php echo $__env->make('frontend.default.inc.css', ['localLang' => $localLang], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- endbuild -->



    <?php
        echo getSetting('header_custom_css');
    ?>

    <?php
        echo getSetting('header_custom_scripts');
    ?> 
    <?php if(getSetting('enable_google_adsense') == 1 && getSetting('adsense_code_snippet')): ?>
        <?php
            echo getSetting('adsense_code_snippet');
        ?>  
    <?php endif; ?>
</head>

<body>  
        <!--Google AdSense-->
        <?php echo adSense_header_top(); ?>

        <!--Google AdSense End-->
    <?php if(getSetting('enable_cookie_consent') == '1'): ?>
        <div class="cookie-alert">
            <div class="p-3 bg-white rounded shadow-lg">
                <div class="mb-3">
                    <?php echo getSetting('cookie_consent_text'); ?>

                </div>
                <button class="btn btn-primary cookie-accept">
                    <?php echo e(localize('I Understood')); ?>

                </button>
            </div>
        </div>
    <?php endif; ?>

    <!--preloader start-->
    <?php if(getSetting('enable_preloader') != '0'): ?>
      <div id="preloader" class="bg-light-subtle">
        <div class="preloader-wrap">
            <img src="<?php echo e(uploadedAsset(getSetting('navbar_logo_dark'))); ?>" class="img-fluid">
            <div class="loading-bar"></div>
        </div>
    </div>
    <?php endif; ?>
    <!--preloader end--> 
   

    <!--main content wrapper start-->
    <main class="tt-main-wrapper position-relative z-1">
        <!--header section start-->
        <?php if(!isset($exception)): ?> <?php echo $__env->make('frontend.default.inc.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php endif; ?>
        <!--header section end--> 
 
        <!--contents start -->
        <?php echo $__env->yieldContent('contents'); ?>
        <!--contents end--> 
       
        <!--scroll to top -->
        <div class="tt-scroll-top scroll-to-target" data-target="html">
            <img src="<?php echo e(uploadedAsset(getSetting('scrol_to_top_image'))); ?>"  onerror="this.src = '<?php echo e(uploadedAsset(getSetting('scrol_to_top_image')) ?? staticAsset('frontend/default/assets/img/website/back-to-top.png')); ?>';" alt="back to top" class="img-fluid">
        </div>
        <!--Google AdSense-->
        <?php echo adSense_top_footer_section(); ?>

        <!--Google AdSense End-->
        <!--footer section start-->
         <?php if(!isset($exception)): ?> <?php echo $__env->make('frontend.default.inc.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> <?php endif; ?>
        <!--footer section end-->
    </main>

        <!--modals-->
        <?php echo $__env->yieldContent('modals'); ?>
        <!--modals--> 
        
    <!-- Offcanvas -->
    <div class="offcanvas
            offcanvas-end subscription-templates-form mb-0" id="offcanvasRight" tabindex="-1">
        <div class="offcanvas-header border-bottom">
            <div class="d-flex justify-content-between w-100 align-items-center">
                <div>
                    <h5 class="offcanvas-title"><?php echo e(localize('Package Templates')); ?></h5>
                </div>
                <div>
                    <span class="btn btn-soft-danger offcanvasRightClose" data-bs-dismiss="offcanvas">
                        <?php echo e(localize('Close')); ?>

                    </span>

                </div>
            </div>
        </div>
        <div class="offcanvas-body" data-simplebar>
            <div class="text-center template-please-wait mt-5"><?php echo e(localize('Please wait')); ?>...</div>
            <div class="package-template-contents"></div>
        </div>
        </div> <!-- offcanvas template end-->

        <!--build:js-->
        <?php echo $__env->make('frontend.default.inc.scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!--endbuild-->

        <!--page's scripts-->
        <?php echo $__env->yieldContent('scripts'); ?>
        <!--page's script-->

        <!-- scripts for common layout - website-admin -->
        <?php echo $__env->yieldContent('scripts-common'); ?>

        <!-- modals for common layout - website-admin -->
        <?php echo $__env->yieldContent('modals-common'); ?>


        <!-- delete modal -->
        <?php echo $__env->make('backend.inc.deleteModal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <?php
            echo getSetting('footer_custom_scripts');
        ?>
        </body>

        </html>
<?php /**PATH E:\xampp\htdocs\ai\baleaspirasi\resources\views/frontend/default/layouts/master.blade.php ENDPATH**/ ?>