<?php
    $user = auth()->user();
    $package = optional(activePackageHistory())->subscriptionPackage != null ? optional(activePackageHistory())->subscriptionPackage : new \App\Models\SubscriptionPackage();
?>

<ul class="tt-side-nav">

    <!-- dashboard -->
    <li class="side-nav-item nav-item">
        <a href="<?php echo e(route('writebot.dashboard')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon"><i data-feather="pie-chart"></i></span>
            <span class="tt-nav-link-text"><?php echo e(localize('Dashboard')); ?></span>
        </a>
    </li>

    <!-- subscriptions -->
    <?php
        $subscriptionActiveRoutes = ['subscriptions.index'];
    ?>
    <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($subscriptionActiveRoutes, 'tt-menu-item-active')); ?>">
        <a data-bs-toggle="collapse" href="#subscription"
            aria-expanded="<?php echo e(areActiveRoutes($subscriptionActiveRoutes, 'true')); ?>" aria-controls="subscription"
            class="side-nav-link tt-menu-toggle">
            <span class="tt-nav-link-icon"><i data-feather="zap"></i></span>
            <span class="tt-nav-link-text"><?php echo e(localize('Subscriptions')); ?></span>
        </a>
        <div class="collapse <?php echo e(areActiveRoutes($subscriptionActiveRoutes, 'show')); ?>" id="subscription">
            <ul class="side-nav-second-level">
                <li class="<?php echo e(areActiveRoutes(['subscriptions.histories.index'], 'tt-menu-item-active')); ?>">
                    <a href="<?php echo e(route('subscriptions.histories.index')); ?>"><?php echo e(localize('Subscription Histories')); ?></a>
                </li>
                <li class="<?php echo e(areActiveRoutes(['subscriptions.index'], 'tt-menu-item-active')); ?>">
                    <a href="<?php echo e(route('subscriptions.index')); ?>"
                        class="<?php echo e(areActiveRoutes(['subscriptions.index'])); ?>"><?php echo e(localize('Subscription Packages')); ?></a>
                </li>
            </ul>
        </div>
    </li>


    <?php if(getSetting('enable_affiliate_system') == '1'): ?>
        <!-- affiliate system -->
        <?php
            $affiliateActiveRoutes = ['affiliate.overview', 'affiliate.payout.configure', 'affiliate.withdraw.index', 'affiliate.earnings.index', 'affiliate.payments.index'];
        ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($affiliateActiveRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#affiliate"
                aria-expanded="<?php echo e(areActiveRoutes($affiliateActiveRoutes, 'true')); ?>" aria-controls="affiliate"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon"><i data-feather="percent"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Affiliate System')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($affiliateActiveRoutes, 'show')); ?>" id="affiliate">
                <ul class="side-nav-second-level">

                    <li class="<?php echo e(areActiveRoutes(['affiliate.overview'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('affiliate.overview')); ?>"><?php echo e(localize('Overview')); ?></a>
                    </li>

                    <li class="<?php echo e(areActiveRoutes(['affiliate.payout.configure'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('affiliate.payout.configure')); ?>"><?php echo e(localize('Payout Configuration')); ?></a>
                    </li>

                    <li class="<?php echo e(areActiveRoutes(['affiliate.earnings.index'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('affiliate.earnings.index')); ?>"><?php echo e(localize('Earning Histories')); ?></a>
                    </li>

                    <li class="<?php echo e(areActiveRoutes(['affiliate.withdraw.index'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('affiliate.withdraw.index')); ?>"><?php echo e(localize('Withdraw Requests')); ?></a>
                    </li>

                    <li class="<?php echo e(areActiveRoutes(['affiliate.payments.index'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('affiliate.payments.index')); ?>"><?php echo e(localize('Payment Histories')); ?></a>
                    </li>

                </ul>
            </div>
        </li>
    <?php endif; ?>

    <!-- documents -->
    <li class="side-nav-title side-nav-item nav-item mt-3">
        <span class="tt-nav-title-text text-muted"><?php echo e(localize('Manage Documents')); ?></span>
    </li>

    <li
        class="side-nav-item nav-item <?php echo e(areActiveRoutes(['folders.index', 'folders.show', 'folders.edit', 'folders.update'], 'tt-menu-item-active')); ?>">
        <a href="<?php echo e(route('folders.index')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon"> <i data-feather="folder-plus"></i></span>
            <span class="tt-nav-link-text"><?php echo e(localize('Folders')); ?></span>
        </a>
    </li>
    <li
    class="side-nav-item nav-item <?php echo e(areActiveRoutes(['projects.index', 'projects.edit', 'projects.update'], 'tt-menu-item-active')); ?>">
        <a href="<?php echo e(route('projects.index')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon"> <i data-feather="grid"></i></span>
            <span class="tt-nav-link-text"><?php echo e(localize('All Projects')); ?></span>
        </a>
    </li>
    <li class="side-nav-title side-nav-item nav-item mt-3">
        <span class="tt-nav-title-text text-muted"><?php echo e(localize('Support')); ?></span>
    </li>
    <!-- Supports -->
    <?php if(isModuleActive('Support')): ?>
        <?php echo $__env->make('support::sidebar.customer_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
   

    <!-- Templates -->
    <li class="side-nav-title side-nav-item nav-item mt-3">
        <span class="tt-nav-title-text text-muted"><?php echo e(localize('AI Tools')); ?></span>
    </li>
    <?php if($package->allow_ai_rewriter == 1 && getSetting('enable_ai_rewriter') != '0'): ?>
   
        <li
            class="side-nav-item nav-item <?php echo e(areActiveRoutes(['aiRewriter.index'], 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('aiRewriter.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="edit-3"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('AI ReWriter')); ?></span>
            </a>
        </li>
    <?php endif; ?>
    <?php if($package->allow_ai_chat == 1 && getSetting('enable_ai_chat') != '0'): ?>
        <li
            class="side-nav-item nav-item <?php echo e(areActiveRoutes(['chat.index', 'chat.experts'], 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('chat.experts')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="message-square"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('AI Chat')); ?></span>
            </a>
        </li>
    <?php endif; ?>
    <?php if($package->allow_ai_vision == 1 && getSetting('enable_ai_vision') != '0'): ?>
        <li
            class="side-nav-item nav-item <?php echo e(areActiveRoutes(['chat.index', 'chat.experts'], 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('vision.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="crosshair"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('AI Vision')); ?></span>
            </a>
        </li>
    <?php endif; ?>
    <?php if($package->allow_ai_pdf_chat == 1 && getSetting('enable_ai_pdf_chat') != '0'): ?>
        <li
            class="side-nav-item nav-item <?php echo e(areActiveRoutes(['pdfChat.index'], 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('pdfChat.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="message-circle"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('AI PDF Chat')); ?></span>
            </a>
        </li>
       
    <?php endif; ?>
    <?php if($package->allow_ai_image_chat == 1 && getSetting('enable_ai_image_chat') != '0'): ?>
        <li
            class="side-nav-item nav-item <?php echo e(areActiveRoutes(['imageChat.index'], 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('imageChat.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="image"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('AI Image Chat')); ?></span>
            </a>
        </li>
    <?php endif; ?>

    <?php if($package->allow_blog_wizard == 1 && getSetting('enable_blog_wizard') != '0'): ?>
        <?php
            $blogWizardActiveRoutes = ['blog.wizard', 'blog.wizard.create', 'blog.wizard.view', 'blog.wizard.edit'];
        ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($blogWizardActiveRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#aiBlogWizard"
                aria-expanded="<?php echo e(areActiveRoutes($blogWizardActiveRoutes, 'true')); ?>" aria-controls="aiBlogWizard"
                class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon"><i data-feather="bold"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('AI Blog Wizard')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($blogWizardActiveRoutes, 'show')); ?>" id="aiBlogWizard">
                <ul class="side-nav-second-level">

                    <li
                        class="<?php echo e(areActiveRoutes(['blog.wizard', 'blog.wizard.view', 'blog.wizard.edit'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('blog.wizard')); ?>"><?php echo e(localize('All Articles')); ?></a>
                    </li>
                    <li class="<?php echo e(areActiveRoutes(['blog.wizard.create'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('blog.wizard.create')); ?>"><?php echo e(localize('Generate Full Article')); ?></a>
                    </li>
                </ul>
            </div>
        </li>
    <?php endif; ?>

    <?php if(getSetting('enable_built_in_templates') != '0' && $package->allow_built_in_templates == 1): ?>
        <li
            class="side-nav-item nav-item <?php echo e(areActiveRoutes(['templates.index', 'templates.show'], 'tt-menu-item-active')); ?>">
            <a href="<?php echo e(route('templates.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="layers"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Templates')); ?></span>
            </a>
        </li>
    <?php endif; ?>

    <!-- custom tempaltes -->
    <?php if($package->allow_custom_templates == 1 && getSetting('enable_custom_templates') != '0'): ?>
        <?php
            $customTemplateActiveRoutes = ['custom.templateCategories.index', 'custom.templateCategories.edit', 'custom.templates.index', 'custom.templates.create', 'custom.templates.edit', 'custom.templates.show'];
        ?>
        <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($customTemplateActiveRoutes, 'tt-menu-item-active')); ?>">
            <a data-bs-toggle="collapse" href="#customTemplates"
                aria-expanded="<?php echo e(areActiveRoutes($customTemplateActiveRoutes, 'true')); ?>"
                aria-controls="customTemplates" class="side-nav-link tt-menu-toggle">
                <span class="tt-nav-link-icon"><i data-feather="codepen"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Custom Templates')); ?></span>
            </a>
            <div class="collapse <?php echo e(areActiveRoutes($customTemplateActiveRoutes, 'show')); ?>" id="customTemplates">
                <ul class="side-nav-second-level">
                    <li
                        class="<?php echo e(areActiveRoutes(['custom.templateCategories.index', 'custom.templateCategories.edit'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('custom.templateCategories.index')); ?>"><?php echo e(localize('Categories')); ?></a>
                    </li>

                    <li
                        class="<?php echo e(areActiveRoutes(['custom.templates.index', 'custom.templates.create', 'custom.templates.edit', 'custom.templates.show'], 'tt-menu-item-active')); ?>">
                        <a href="<?php echo e(route('custom.templates.index')); ?>"><?php echo e(localize('All Templates')); ?></a>
                    </li>
                </ul>
            </div>
        </li>
    <?php endif; ?>
    <?php if(getSetting('enable_ai_images') != '0'): ?>
        <?php if($package->allow_images == 1 || $package->allow_sd_images == 1): ?>
            <?php
                $imagesActiveRoutes = ['images.index', 'sdImages.index'];
            ?>

            <li class="side-nav-item nav-item <?php echo e(areActiveRoutes($imagesActiveRoutes, 'tt-menu-item-active')); ?>">
                <a data-bs-toggle="collapse" href="#generateImages"
                    aria-expanded="<?php echo e(areActiveRoutes($imagesActiveRoutes, 'true')); ?>" aria-controls="generateImages"
                    class="side-nav-link tt-menu-toggle">
                    <span class="tt-nav-link-icon"><i data-feather="image"></i></span>
                    <span class="tt-nav-link-text"><?php echo e(localize('AI Images')); ?></span>
                </a>
                <div class="collapse <?php echo e(areActiveRoutes($imagesActiveRoutes, 'show')); ?>" id="generateImages">
                    <ul class="side-nav-second-level">
                        <?php if($package->allow_images == 1): ?>
                            <li class="<?php echo e(areActiveRoutes(['images.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('images.index')); ?>"><?php echo e(localize('Dall-E 2')); ?></a>
                            </li>
                            <li class="<?php echo e(areActiveRoutes(['images.dall-e-3'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('images.dall-e-3')); ?>"><?php echo e(localize('Dall-E 3')); ?></a>
                            </li>
                        <?php endif; ?>

                        <?php if($package->allow_sd_images == 1): ?>
                            <li class="<?php echo e(areActiveRoutes(['sdImages.index'], 'tt-menu-item-active')); ?>">
                                <a href="<?php echo e(route('sdImages.index')); ?>"><?php echo e(localize('Stable Diffusion')); ?></a>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </li>
        <?php endif; ?>
    <?php endif; ?>

    <?php if($package->allow_text_to_speech == 1 && getSetting('enable_text_to_speech') != '0'): ?>
    <li class="side-nav-item nav-item">
        <a href="<?php echo e(route('t2s.index')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon"> <i data-feather="volume-2"></i></span>
            <span class="tt-nav-link-text"><?php echo e(localize('Text To Speech')); ?></span>
        </a>
    </li>
<?php endif; ?>
<?php if($package->allow_speech_to_text == 1 && getSetting('enable_speech_to_text') != '0'): ?>
<li class="side-nav-item nav-item">
    <a href="<?php echo e(route('s2t.index')); ?>" class="side-nav-link">
        <span class="tt-nav-link-icon"> <i data-feather="mic"></i></span>
        <span class="tt-nav-link-text"><?php echo e(localize('Speech to Text')); ?></span>
    </a>
</li>
<?php endif; ?>
<?php if($package->allow_eleven_labs == 1 && getSetting('enable_eleven_labs') != '0'): ?>
    <li class="side-nav-item nav-item">
        <a href="<?php echo e(route('t2s.index.eleven-labs')); ?>" class="side-nav-link">
            <span class="tt-nav-link-icon"> <i data-feather="volume-2"></i></span>
            <span class="tt-nav-link-text"><?php echo e(localize('Eleven Labs')); ?></span>
        </a>
    </li>
<?php endif; ?>



    <?php if($package->allow_ai_code == 1 && getSetting('enable_ai_code') != '0'): ?>
        <li class="side-nav-item nav-item">
            <a href="<?php echo e(route('codes.index')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"> <i data-feather="code"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('AI Code')); ?></span>
            </a>
        </li>
    <?php endif; ?>
 


    <?php if(getSetting('enable_built_in_templates') != '0' && $package->allow_built_in_templates == 1): ?>
        <!-- popular templates -->
        <li class="side-nav-item nav-item">
            <a href="<?php echo e(route('templates.popular')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"><i data-feather="award"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Popular Templates')); ?></span>
            </a>
        </li>

        <!-- favorite templates -->
        <li class="side-nav-item nav-item">
            <a href="<?php echo e(route('templates.favorites')); ?>" class="side-nav-link">
                <span class="tt-nav-link-icon"><i data-feather="heart"></i></span>
                <span class="tt-nav-link-text"><?php echo e(localize('Favorite Templates')); ?></span>
            </a>
        </li>
    <?php endif; ?>

</ul>
<?php /**PATH E:\xampp\htdocs\ai\baleaspirasi\resources\views/backend/inc/userSidebarMenus.blade.php ENDPATH**/ ?>