<?php

namespace App\Http\Controllers\Backend\Payments\Duitku;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\GrassPeriodPayment;
use App\Models\SubscriptionHistory;
use Illuminate\Support\Facades\Log;
use Royryando\Duitku\Facades\Duitku;
use Illuminate\Support\Facades\Redirect;
use Royryando\Duitku\Enums\DuitkuCallbackCode;
use Royryando\Duitku\Http\Controllers\DuitkuBaseController;
use App\Http\Controllers\Backend\Payments\PaymentsController;

class DuitkuController extends DuitkuBaseController
{
    # duitku payment view
    public function initPayment()
    {
        $user = auth()->user();
        $amount = session('amount');
        $methods = Duitku::paymentMethods((float)$amount);
        return view('payments.duitku', compact('methods'));
    }

    # duitku payment
    public function pay(Request $request)
    {
        $amount = session('amount');
        $method = $request->input('payment_method');
        $user = auth()->user();
        /*
         * Create invoice
         */
        $response = Duitku::createInvoice('subscription-' . time(), (float) $amount, $method, 'Subscription package', $user->name, $user->email, 30);
        if (!$response['success']) {
            abort(400, $response['message']);
        }
        /*
         * Redirect to the payment url
         */
        return Redirect::to($response['payment_url']);
    }

    # callback
    protected function paymentCallback(Request $request)
    {
        Log::info("Duitku payment callback :" .$request);
        try {
            $merchantCode = config('duitku.merchant_code');
            $apiKey = config('duitku.api_key');
            $amount = $request->input('amount');
            $merchantOrderId = $request->input('merchantOrderId');
            $resultCode = $request->input('resultCode');
            $signature = $request->input('signature');

            if($resultCode == '00'){
                $transaction_status = 'success';
            }else if($resultCode == '01') {
                $transaction_status = 'pending';
            }else{
                $transaction_status ='cancel';
            }

            $pendingRecord = GrassPeriodPayment::where('order_id', $merchantOrderId)->where('transaction_status', 'pending')->first();
            $user  = User::where('id', $pendingRecord->user_id)->first();
            $subscription_history = SubscriptionHistory::where('user_id', $user->id)->where('order_id', $merchantOrderId)->first();
            $data = [
                'json' => true,
                'order_id'=>$merchantOrderId
            ];


            if (!empty($merchantCode) && !empty($amount) && !empty($merchantOrderId) && !empty($signature)) {
                $params = $merchantCode . $amount . $merchantOrderId . $apiKey;
                $calcSignature = md5($params);

                if ($signature == $calcSignature) {
                    if ($resultCode == DuitkuCallbackCode::SUCCESS) {
                        // Payment success
                        if($pendingRecord) {
                            return (new PaymentsController)->payment_success(null, $user, $pendingRecord->subscription_package_id, $pendingRecord->subscriptionPackage->price, 'duitku', $data);
                        }else {
                            $this->success();
                        }
                    } else {
                        // Payment failed or expired
                        $this->failed();
                    }
                } else {
                    // Bad signature
                    $this->failed();
                }
            } else {
                // FAILED
                $this->failed();
            }

            if($pendingRecord && empty($signature) && $merchantOrderId) {
                return (new PaymentsController)->payment_success(null, $user, $pendingRecord->subscription_package_id, $pendingRecord->subscriptionPackage->price, 'duitku', $data);
            }

        } catch (\Exception $ex) {
            Log::info("Duitku payment callback :" .$ex->getMessage());
            $this->failed();
        }
    }
    # success
    protected function success()
    {
        try {
            $payment = ["status" => "Success"];
            return (new PaymentsController)->payment_success(json_encode($payment));
        } catch (\Exception $e) {
            return (new PaymentsController)->payment_failed();
        }
    }

    # failed
    protected function failed()
    {
        return (new PaymentsController)->payment_failed();
    }

    # return
    public function myReturnCallback(Request $request)
    {
        $merchantOrderId = $request->input('merchantOrderId');
        $resultCode = $request->input('resultCode');


        if($resultCode == '00'){
            $transaction_status = 'success';
        }else if($resultCode == '01') {
            $transaction_status = 'pending';
        }else{
            $transaction_status ='cancel';
        }

        $pendingRecord = GrassPeriodPayment::where('order_id', $merchantOrderId)->where('transaction_status', 'pending')->first();
        // No GrassPeriodPayment
        if(empty($pendingRecord)){
            flash("Grass Period Payment Not Found by merchant order id")->error();
            return (new PaymentsController)->payment_failed();
        }
        $user  = User::where('id', $pendingRecord->user_id)->first();
        $subscription_history = SubscriptionHistory::where('user_id', $user->id)->where('order_id', $merchantOrderId)->first();
        $data = [
            'json' => true,
            'order_id'=>$merchantOrderId
        ];


        if ($request->resultCode) {
            if ($request->resultCode == DuitkuCallbackCode::SUCCESS) {
                if($pendingRecord) {
                    return (new PaymentsController)->payment_success(null, $user, $pendingRecord->subscription_package_id, $pendingRecord->subscriptionPackage->price, 'duitku', $data);
                }else {
                    $this->success();
                }
            }
        }else if($request->resultCode == '01') {

            $this->storeGrassPeriod($merchantOrderId, $transaction_status, $resultCode, null);
            flash(localize('Waiting for payment'))->error();
            clearPaymentSession();
            return redirect()->route('subscriptions.index');
        }
        return (new PaymentsController)->payment_failed();
    }
    public  function storeGrassPeriod($order_id, $transaction_status, $status_code, $response)
    {
        GrassPeriodPayment::updateOrCreate(
            [
                'order_id'=>$order_id,
                'user_id' => auth()->user()->id,
                'subscription_package_id' => session('package_id'),
            ],
            [
                'transaction_status' => $transaction_status,
                'status_code' => $status_code,
                'response' => $response,
                'gateway'=>'Duitku'
            ]
        );
    }
}
